<?php
add_filter( 'max_srcset_image_width', 'oxpitan_max_srcset_image_width' );
function oxpitan_max_srcset_image_width(){
  return 1;
}
remove_action('wp_head', 'wp_oembed_add_discovery_links', 10);

add_theme_support( 'wp-block-styles' );

/**
 * Hook to before breadcrumb
 */
function oxpitan_style_breadcrumb(){
  global $post;
  $post_id = oxpitan_id();
  $result['title'] = '';
  $result['styles'] = '';
  $result['styles_overlay'] = '';
  $result['classes'] = '';

  $show_no_breadcrumbs = oxpitan_get_option('enable_breadcrumb', 'enable') == 'disable' ? true : false;
  if(get_post_meta($post_id, 'oxpitan_no_breadcrumbs', true) == true){
    $show_no_breadcrumbs = true;
  }
  $show_page_title = get_post_meta($post_id, 'oxpitan_page_title', true);
  $page_title_one = get_post_meta($post_id, 'oxpitan_page_title_one', true);
  $bg_color_title = get_post_meta($post_id, 'oxpitan_bg_color_title', true);
  $bg_opacity_title = get_post_meta($post_id, 'oxpitan_bg_opacity_title', true);
  $page_title_image = get_post_meta( $post_id, 'oxpitan_page_title_image', true );
  $page_title_text_style = get_post_meta($post_id, 'oxpitan_page_title_text_style', true );
  $page_title_text_align = get_post_meta($post_id, 'oxpitan_page_title_text_align', true) ? get_post_meta($post_id, 'oxpitan_page_title_text_align', true) : 'text-center';
  if ( metadata_exists( 'post', $post_id, 'oxpitan_page_title' ) || is_archive()) {
    $show_page_title = true;
  }

  //Breadcrumb category and tag products
  if(oxpitan_woocommerce_activated() && (is_product_tag() || is_product_category() || is_shop()) ){
    $show_page_title = oxpitan_get_option('woo_show_page_heading', true);
    $bg_color_title = oxpitan_get_option('woo_page_heading_background_color', ''); 
    $bg_opacity_title = oxpitan_get_option('woo_page_heading_bg_opacity_title', 0);
    $page_title_image = oxpitan_get_option('woo_page_heading_image', array('id'=> 0));
    $page_title_text_style = oxpitan_get_option('woo_page_heading_text_style', 'text-dark');
    $page_title_text_align = oxpitan_get_option('woo_page_heading_text_align', 'text-center');
    if(isset($page_title_image['id']) && $page_title_image['id']){
      $page_title_image = $page_title_image['id'];
    }else{
      $page_title_image = '';
    }
  }

  $result = array();
  $styles = array();
  $styles_overlay = '';
  $classes = array();
  $title = '';
  if($show_no_breadcrumbs){
    $result['no_breadcrumbs'] = true;
  }

  if(!isset($show_page_title) || empty($show_page_title) || $show_page_title){
    $title = get_the_title();
    if(is_archive()) $title = single_cat_title('', false);
    if(oxpitan_woocommerce_activated() && is_shop()){
      $title = woocommerce_page_title(false);
    }
    if($page_title_one){
      $title = $page_title_one;
    }   
  }

  if(is_home()) {
    $show_page_title = true;
    $title = esc_html__( 'Latest posts', 'oxpitan' );
  }
  
  if($bg_color_title){
    $rgba_color = oxpitan_convert_hextorgb($bg_color_title);
    $styles_overlay = 'background-color: rgba(' . esc_attr($rgba_color['r']) . ',' . esc_attr($rgba_color['g']) . ',' . esc_attr($rgba_color['b']) . ', ' . ($bg_opacity_title/100) . ')';
  }
  //Classes
  $classes[] = $page_title_text_style;
  $classes[] = $page_title_text_align;
  $image_background_breadcrumb = '';
  if(!$page_title_image){
    $page_title_image = oxpitan_get_option('breadcrumb_background_image_default', array('id'=> 0));
  }
  if($page_title_image){
    if(isset($page_title_image['id']) && $page_title_image['id'] && !is_numeric($page_title_image)){
      if($page_title_image['id'] && is_numeric($page_title_image['id'])){
        $page_title_image = $page_title_image['id'];
      }
    }
    $image = wp_get_attachment_image_src( $page_title_image, 'full');
    if(isset($image[0]) && $image[0]){
      $image_background_breadcrumb = esc_url($image[0]);
    }
  }

  if($image_background_breadcrumb){
    $styles[] = 'background-image: url(\'' . $image_background_breadcrumb . '\')';
  }

  if(is_single() && empty($page_title_one)){
    $title = get_the_title();
  }

  if(is_search() || get_query_var('s')){
    $title = 'Search results for "' . get_search_query() . '"';
  }

  $result['title'] = $title;
  $result['styles'] = $styles;
  $result['styles_overlay'] = $styles_overlay;
  $result['classes'] = $classes;
  $result['show_page_title'] = $show_page_title;
  return $result;
}

function oxpitan_breadcrumb(){
   $result = oxpitan_style_breadcrumb();
   extract($result);
   if(isset($no_breadcrumbs) && $no_breadcrumbs == true){
    echo '<div class="disable-breadcrumb clearfix"></div>';
    return false;
   }
    $image_breadcumb_standard = oxpitan_get_option('image_breadcumb_standard', 'show-bg');
    $classes[] = $image_breadcumb_standard;
   ?>
   
   <div class="custom-breadcrumb <?php echo implode(' ', $classes); ?>" <?php echo(count($styles) > 0 ? 'style="' . implode(';', $styles) . '"' : ''); ?>>
      <?php if($styles_overlay){ ?>
         <div class="breadcrumb-overlay" style="<?php echo esc_attr($styles_overlay); ?>"></div>
      <?php } ?>
      <div class="breadcrumb-main">
        <div class="container">
          <div class="breadcrumb-container-inner">
            <?php if($title && ( $show_page_title || empty($show_page_title) ) ){ 
              echo '<h2 class="heading-title">' . esc_html( $title ) . '</h2>';
            } ?>
            <?php oxpitan_general_breadcrumbs(); ?>
          </div>  
        </div>   
      </div>  
   </div>
   <?php
}

add_action( 'oxpitan_before_page_content', 'oxpitan_breadcrumb', '10' );


/**
 * Hook to select header of page
 */
function oxpitan_get_header_layouts( $header='' ){

  $pid = oxpitan_id();
  $header = (get_post_meta( $pid, 'oxpitan_page_header', true )) ? get_post_meta( $pid, 'oxpitan_page_header', true ) : '';
  
  if ( $header == '__default_option_theme' || empty($header)){
    $header = oxpitan_get_option('header_layout', '');
  }else{
    return trim( $header );
  }

  if($header=='v__'){
    $header ='';
  }

  return $header;
} 
add_filter( 'oxpitan_get_header_layout', 'oxpitan_get_header_layouts' );

/**
 * Hook to select footer of page
 */
function oxpitan_get_footer_layout( $footer = '' ){
  $post = get_post();
  
  $footer = ($post && get_post_meta( $post->ID, 'oxpitan_page_footer', true )) ? get_post_meta( $post->ID, 'oxpitan_page_footer', true ) : '__default_option_theme';
  
  if ( $footer == '__default_option_theme'){
    $footer = oxpitan_get_option('footer_layout', '');
  }else{
    return trim( $footer );
  }

  return $footer;
} 
add_filter( 'oxpitan_get_footer_layout', 'oxpitan_get_footer_layout' );

function oxpitan_main_menu(){
  if(has_nav_menu( 'primary' )){
    $oxpitan_menu = array(
      'theme_location'    => 'primary',
      'container'         => 'div',
      'container_class'   => 'navbar-collapse',
      'container_id'      => 'gva-main-menu',
      'menu_class'        => ' gva-nav-menu gva-main-menu',
      'walker'            => new Oxpitan_Walker()
    );
    wp_nav_menu($oxpitan_menu);
  }  
}
add_action( 'oxpitan_main_menu', 'oxpitan_main_menu', 10 );
 
function oxpitan_mobile_menu(){
  if(has_nav_menu( 'primary' )){
    $oxpitan_menu = array(
      'theme_location'    => 'primary',
      'container'         => 'div',
      'container_class'   => 'navbar-collapse',
      'container_id'      => 'gva-mobile-menu',
      'menu_class'        => 'gva-mobile-menu',
      'walker'            => new Oxpitan_Walker()
    );
    wp_nav_menu($oxpitan_menu);
  }  
}
add_action( 'oxpitan_mobile_menu', 'oxpitan_mobile_menu', 10 );

function oxpitan_my_account_menu(){
  if(has_nav_menu( 'my_account' )){
    $oxpitan_menu = array(
      'theme_location'    => 'my_account',
      'container'         => 'div',
      'container_class'   => 'navbar-collapse',
      'container_id'      => 'gva-my-account-menu',
      'menu_class'        => 'gva-my-account-menu',
      'walker'            => new Oxpitan_Walker()
    );
    wp_nav_menu($oxpitan_menu);
  }  
}
add_action( 'oxpitan_my_account_menu', 'oxpitan_my_account_menu', 11 );

function oxpitan_header_mobile(){
  get_template_part('templates/parts/header', 'mobile');
}
add_action('oxpitan_header_mobile', 'oxpitan_header_mobile', 10);


if ( !function_exists( 'oxpitan_style_footer' ) ) {
  function oxpitan_style_footer(){
    $footer = oxpitan_get_footer_layout(''); 
    
    if($footer!='default'){
      $shortcodes_custom_css = get_post_meta( $footer, '_wpb_shortcodes_custom_css', true );
      if ( ! empty( $shortcodes_custom_css ) ) {
        echo '<style>
          '.$shortcodes_custom_css.'
          </style>';
      }
    }
  }
  add_action('wp_head','oxpitan_style_footer', 18);
}

add_filter('gavias-elements/map-api', 'oxpitan_googlemap_api');
if(!function_exists('oxpitan_googlemap_api')){
    function oxpitan_googlemap_api( $key = '' ){
        return oxpitan_get_option('map_api_key', '');
    }
}

function oxpitan_load_posttypes_default(){
  return array('megamenu');
}
add_filter( 'gaviasthemer_load_posttypes_default', 'oxpitan_load_posttypes_default', 11, 2 );

function oxpitan_setup_admin_setting(){
  global $pagenow; 
  if ( is_admin() && isset($_GET['activated'] ) && $pagenow == 'themes.php' ) {
    update_option( 'gaviasthemer_active_post_types', array() );
    update_option( 'thumbnail_size_w', 180 );  
    update_option( 'thumbnail_size_h', 180 );  
    update_option( 'thumbnail_crop', 1 );  
    update_option( 'medium_size_w', 750 );  
    update_option( 'medium_size_h', 510 ); 
    update_option( 'medium_crop', 1 );  
  }
}
add_action( 'init', 'oxpitan_setup_admin_setting'  );

if ( !function_exists( 'oxpitan_page_class_names' ) ) {
  function oxpitan_page_class_names( $classes ) {
    $class_el = get_post_meta( oxpitan_id(), 'oxpitan_extra_page_class', true  );
    if($class_el) $classes[] = $class_el;
    return $classes;
  }
}
add_filter( 'body_class', 'oxpitan_page_class_names' );

