<?php
function oxpitan_register_meta_boxes(){

   $prefix = 'oxpitan_';
   global $meta_boxes, $wp_registered_sidebars;;
   $sidebar = array();
   $sidebar[""] = ' --Default-- ';
   foreach($wp_registered_sidebars as $key => $value){
      $sidebar[$value['id']] = $value['name'];
   }
   $default_options = get_option('oxpitan_options');
   
   $meta_boxes = array();

   /* Thumbnail Meta Box
   ================================================== */
   $meta_boxes[] = array(
      'id' => 'gavias_metaboxes_post_thumbnail',
      'title' => esc_html__('Thumbnail', 'oxpitan'),
      'pages' => array( 'post' ),
      'context' => 'normal',
      'fields' => array(
         
         // THUMBNAIL IMAGE
         array(
            'name'  => esc_html__('Thumbnail image', 'oxpitan'),
            'desc'  => esc_html__('The image that will be used as the thumbnail image.', 'oxpitan'),
            'id'    => "{$prefix}thumbnail_image",
            'type'  => 'image_advanced',
            'max_file_uploads' => 1
         ),

         // THUMBNAIL VIDEO
         array(
            'name' => esc_html__('Thumbnail video URL', 'oxpitan'),
            'id' => $prefix . 'thumbnail_video_url',
            'desc' => esc_html__('Enter the video url for the thumbnail. Only links from Vimeo & YouTube are supported.', 'oxpitan'),
            'clone' => false,
            'type'  => 'oembed',
            'std' => '',
         ),

         // THUMBNAIL AUDIO
         array(
            'name' => esc_html__('Thumbnail audio URL', 'oxpitan'),
            'id' => "{$prefix}thumbnail_audio_url",
            'desc' => esc_html__('Enter the audio url for the thumbnail.', 'oxpitan'),
            'clone' => false,
            'type'  => 'oembed',
            'std' => '',
         ),

         // THUMBNAIL GALLERY
         array(
            'name'             => esc_html__('Thumbnail gallery', 'oxpitan'),
            'desc'             => esc_html__('The images that will be used in the thumbnail gallery.', 'oxpitan'),
            'id'               => "{$prefix}thumbnail_gallery",
            'type'             => 'image_advanced',
            'max_file_uploads' => 50,
         ),

         // THUMBNAIL LINK TYPE
         array(
            'name' => esc_html__('Thumbnail link type', 'oxpitan'),
            'id'   => "{$prefix}thumbnail_link_type",
            'type' => 'select',
            'options' => array(
               'link_to_post'    => esc_html__('Link to item', 'oxpitan'),
               'link_to_url'     => esc_html__('Link to URL', 'oxpitan'),
               'link_to_url_nw'  => esc_html__('Link to URL (New Window)', 'oxpitan'),
               'lightbox_thumb'  => esc_html__('Lightbox to the thumbnail image', 'oxpitan'),
               'lightbox_image'  => esc_html__('Lightbox to image (select below)', 'oxpitan'),
               'lightbox_video'  => esc_html__('Fullscreen Video Overlay (input below)', 'oxpitan')
            ),
            'multiple' => false,
            'std'  => 'link-to-post',
            'desc' => esc_html__('Choose what link will be used for the image(s) and title of the item.', 'oxpitan')
         ),

         // THUMBNAIL LINK URL
         array(
            'name' => esc_html__('Thumbnail link URL', 'oxpitan'),
            'id' => $prefix . 'thumbnail_link_url',
            'desc' => esc_html__('Enter the url for the thumbnail link.', 'oxpitan'),
            'clone' => false,
            'type'  => 'text',
            'std' => '',
         ),

         // THUMBNAIL LINK LIGHTBOX IMAGE
         array(
            'name'  => esc_html__('Thumbnail link lightbox image', 'oxpitan'),
            'desc'  => esc_html__('The image that will be used as the lightbox image.', 'oxpitan'),
            'id'    => "{$prefix}thumbnail_link_image",
            'type'  => 'thickbox_image'
         ),
      )
   );

    /* Page Meta Box
   ================================================== */
   $meta_boxes[] = array(
      'id'    => 'gavias_metaboxes_page',
      'title' => esc_html__('Page Meta', 'oxpitan'),
      'pages' => array( 'page', 'portfolio', 'product', 'post', 'give_forms' ),
      'priority'   => 'high',
      'fields' => array(
         // Full width
         array(
            'name' => esc_html__('Full Width( 100% Main Width )', 'oxpitan'),
            'id'   => "{$prefix}page_full_width",
            'type' => 'switch',
            'desc' => esc_html__('Turn on to have the main area display at 100% width according to the window size. Turn off to follow site width.', 'oxpitan'),
            'std' => 0,
         ),
         // Extra Page Class
         array(
            'name' => esc_html__('Header', 'oxpitan'),
            'id' => $prefix . 'page_header',
            'desc' => esc_html__("You can change header for page if you like's.", 'oxpitan'),
            'type'  => 'select',
            'options'   => oxpitan_get_headers(),
            'std' => '__default_option_theme',
         ),
         array(
            'name'      => esc_html__('Footer', 'oxpitan'),
            'id'        => $prefix . 'page_footer',
            'desc'      => esc_html__("You can change footer for page if you like's",'oxpitan'),
            'type'      => 'select',
            'options'   =>  oxpitan_get_footer(),
            'std'       => '__default_option_theme'
         ),
         // Extra Page Class
         array(
            'name' => esc_html__('Extra page class', 'oxpitan'),
            'id' => $prefix . 'extra_page_class',
            'desc' => esc_html__("If you wish to add extra classes to the body class of the page (for custom css use), then please add the class(es) here.", 'oxpitan'),
            'clone' => false,
            'type'  => 'text',
            'std' => '',
         ),
        
      )
   );

   /* Page Title Meta Box
   ================================================== */
   $meta_boxes[] = array(
      'id' => 'gavias_metaboxes_page_heading',
      'title' => esc_html__('Page Title', 'oxpitan'),
      'pages' => array( 'post', 'page', 'product', 'portfolio', 'gallery', 'give_forms', 'gva_event', 'gva_team'),
      'context' => 'normal',
      'priority'   => 'high',
      'fields' => array(

        array(
          'name' => esc_html__('Remove Title of Page', 'oxpitan'),   
          'id'   => "{$prefix}disable_page_title",
          'type' => 'switch',
          'std'  => 0,
        ),

         // SHOW PAGE TITLE
        array(
          'name' => esc_html__('Show page title in the breadcrumbs', 'oxpitan'),   
          'id'   => "{$prefix}page_title",
          'type' => 'switch',
          'std'  => 1,
        ),


         // PAGE TITLE LINE 1
        array(
          'name' => esc_html__('Page Title', 'oxpitan'),
          'id' => $prefix . 'page_title_one',
          'desc' => esc_html__("Enter a custom page title if you'd like.", 'oxpitan'),
          'type'  => 'text',
          'std' => '',
        ),

         // PAGE TITLE BACKGROUND COLOR
        array(
          'name' => esc_html__( 'Hero Overlay Color', 'oxpitan' ),
          'id'   => "{$prefix}bg_color_title",
          'desc' => esc_html__( "Set an overlay color for hero heading image.", 'oxpitan' ),
          'type' => 'color',
          'std'  => '',
        ),
            
        // Overlay Opacity Value
        array(
          'name'       => esc_html__( 'Overlay Opacity', 'oxpitan' ),
          'id'         => "{$prefix}bg_opacity_title",
          'desc'       => esc_html__( 'Set the opacity level of the overlay. This will lighten or darken the image depening on the color selected.', 'oxpitan' ),
          'clone'      => false,
          'type'       => 'slider',
          'prefix'     => '',
          'js_options' => array(
              'min'  => 0,
              'max'  => 100,
              'step' => 1,
          ),
          'std'   => '50'
        ),

        // HERO HEADING IMAGE UPLOAD
        array(
          'name'  => esc_html__('Breadcrumb Background Image', 'oxpitan'),
          'desc'  => esc_html__('The image that will be used as the background for the hero header.', 'oxpitan'),
          'id'    => "{$prefix}page_title_image",
          'type'  => 'image_advanced',
          'max_file_uploads' => 1
        ),

        // HERO HEADING TEXT STYLE
        array(
          'name' => esc_html__('Heading Text Style', 'oxpitan'),
          'id'   => "{$prefix}page_title_text_style",
          'type' => 'select',
          'options' => array(
             'text-light'     => esc_html__('Light', 'oxpitan'),
             'text-dark'      => esc_html__('Dark', 'oxpitan')
          ),
          'multiple' => false,
          'std'  => 'text-dark',
          'desc' => esc_html__('If you uploaded an image in the option above, choose light/dark styling for the text heading text here.', 'oxpitan')
        ),

        // HERO HEADING TEXT ALIGN
        array(
          'name' => esc_html__('Heading Text Align', 'oxpitan'),
          'id'   => "{$prefix}page_title_text_align",
          'type' => 'select',
          'options' => array(
             'text-left'      => esc_html__('Left', 'oxpitan'),
             'text-center'    => esc_html__('Center', 'oxpitan'),
             'text-right'     => esc_html__('Right', 'oxpitan')
          ),
          'multiple' => false,
          'std'  => 'text-center',
          'desc' => esc_html__('Choose the text alignment for the hero heading.', 'oxpitan')
        ),

        // REMOVE BREADCRUMBS
        array(
          'name' => esc_html__('Remove breadcrumbs', 'oxpitan'),
          'id'   => "{$prefix}no_breadcrumbs",
          'type' => 'switch',
          'desc' => esc_html__('Remove the breadcrumbs from under the page title on this page.', 'oxpitan'),
          'std' => 0,
        )
      )
   );

  
   /* Brands Meta Box
   ================================================== */
   $meta_boxes[] = array(
      'id'    => 'gavias_metaboxes_brands_options',
      'title' => esc_html__('Brands Options', 'oxpitan'),
      'pages' => array( 'brands'),
      'priority'   => 'high',
      'fields' => array(
         // LEFT SIDEBAR
         array (
            'name'   => esc_html__('Url Link', 'oxpitan'),
             'id'    => "{$prefix}url_link",
             'type' => 'text',
             'std'   => ''
         ),
      )
   );

   /* Sidebar Meta Box Page
   ================================================== */
   $meta_boxes[] = array(
      'id'    => 'gavias_metaboxes_sidebar_page',
      'title' => esc_html__('Sidebar Options', 'oxpitan'),
      'pages' => array( 'post', 'page', 'product', 'portfolio', 'gallery', 'give_forms', 'gva_event' ),
      'priority'   => 'high',
      'fields' => array(

         // SIDEBAR CONFIG
         array(
            'name' => esc_html__('Sidebar configuration', 'oxpitan'),
            'id'   => "{$prefix}sidebar_config",
            'type' => 'select',
            'options' => array(
              ''                   => esc_html__('--Default--', 'oxpitan'),
              'no-sidebars'        => esc_html__('No Sidebars', 'oxpitan'),
              'left-sidebar'       => esc_html__('Left Sidebar', 'oxpitan'),
              'right-sidebar'      => esc_html__('Right Sidebar', 'oxpitan'),
              'both-sidebars'      => esc_html__('Both Sidebars', 'oxpitan')
            ),
            'multiple' => false,
            'std'  => '',
            'desc' => esc_html__('Choose the sidebar configuration for the detail page of this page.', 'oxpitan'),
         ),

         // LEFT SIDEBAR
         array (
            'name'   => esc_html__('Left Sidebar', 'oxpitan'),
             'id'    => "{$prefix}left_sidebar",
             'type' => 'select',
             'options'  => $sidebar,
             'std'   => ''
         ),

         // RIGHT SIDEBAR
         array (
            'name'   => esc_html__('Right Sidebar', 'oxpitan'),
            'id'    => "{$prefix}right_sidebar",
            'type' => 'select',
            'options'  => $sidebar,
            'std'   => ''
         ),
      )
   );

  /* Gallery Meta Box 
  ================================================== */
  $meta_boxes[] = array(
    'id'    => 'metaboxes_portfolio_page',
    'title' => esc_html__('Portfolio Settings', 'oxpitan'),
    'pages' => array( 'portfolio' ),
    'priority'   => 'high',
    'fields' => array(
      array (
        'name'   => esc_html__('Gallery Images', 'oxpitan'),
        'id'    => "{$prefix}gallery_images",
        'type'             => 'image_advanced',
        'max_file_uploads' => 50,
      ),
    )
  );

  $meta_boxes[] = array(
    'id'    => 'metaboxes_gallery_page',
    'title' => esc_html__('Gallery Settings', 'oxpitan'),
    'pages' => array( 'gallery' ),
    'priority'   => 'high',
    'fields' => array(
      array (
        'name'   => esc_html__('Gallery Images', 'oxpitan'),
        'id'    => "{$prefix}gallery_images",
        'type'             => 'image_advanced',
        'max_file_uploads' => 50,
      ),
      array(
        'name'    => esc_html__('Color', 'oxpitan'),
        'id'      => "{$prefix}gallery_color",
        'type'    => 'select',
        'options' => oxpitan_scheme_colors()
      )
    )
  );

   $map_api_key = oxpitan_get_option('map_api_key', 'AIzaSyChkvQkXo_61RR7u-XJOj-rLF9ekk9eRYc'); 
    /* Event Meta Box 
   ================================================== */
   $meta_boxes[] = array(
      'id'            => 'metaboxes_event_page',
      'title'         => esc_html__('Event Settings', 'oxpitan'),
      'pages'         => array( 'gva_event' ),
      'priority'   => 'high',
      'fields'        => array(
        array (
          'name'    => esc_html__('Start Time', 'oxpitan'),
          'id'      => "{$prefix}start_time",
          'type'    => 'datetime'
        ),
        array (
          'name'    => esc_html__('Finished Time', 'oxpitan'),
          'id'      => "{$prefix}finish_time",
          'type'    => 'datetime'
        ),
        array (
          'name'    => esc_html__('Time', 'oxpitan'),
          'id'      => "{$prefix}_time",
          'type'    => 'text',
          'placeholder' => esc_html__('8:00am to 2:00pm', 'oxpitan')
        ),
        array (
          'name'    => esc_html__('Address', 'oxpitan'),
          'id'      => "{$prefix}address",
          'type'    => 'text',
          'placeholder' => esc_html__('San marcos', 'oxpitan')
        ),
        array (
          'name'    => esc_html__('Google Map', 'oxpitan'),
          'id'      => "{$prefix}map",
          'type'    => 'map',
          'address_field' => "{$prefix}address",
          'api_key'   => $map_api_key
        ),
        array(
          'name'    => esc_html__('Color', 'oxpitan'),
          'id'      => "{$prefix}event_color",
          'type'    => 'select',
          'options' => oxpitan_scheme_colors()
        )
      ),
   );

  $meta_boxes[] = array(
    'id'    => 'metaboxes_team_page',
    'title' => esc_html__('Team Settings', 'oxpitan'),
    'pages' => array( 'gva_team' ),
    'priority'   => 'high',
    'fields' => array(
      array (
        'name'   => esc_html__('Position', 'oxpitan'),
        'id'    => "{$prefix}team_position",
        'type' => 'text',
        'std'   => ''
      ),
      array (
        'name'   => esc_html__('Quote', 'oxpitan'),
        'id'    => "{$prefix}team_quote",
        'type' => 'textarea',
        'std'   => ''
      ),
      array (
        'name'   => esc_html__('Email', 'oxpitan'),
        'id'    => "{$prefix}team_email",
        'type' => 'text',
        'std'   => ''
      ),
      array (
        'name'   => esc_html__('Phone', 'oxpitan'),
        'id'    => "{$prefix}team_phone",
        'type' => 'text',
        'std'   => ''
      ),
      array (
        'name'   => esc_html__('Address', 'oxpitan'),
        'id'    => "{$prefix}team_address",
        'type' => 'text',
        'std'   => ''
      ),
      array(
        'name'    => esc_html__('Color', 'oxpitan'),
        'id'      => "{$prefix}team_color",
        'type'    => 'select',
        'options' => oxpitan_scheme_colors()
      ),
      array(
        'name' => esc_html__('Text Color', 'oxpitan'),
        'id'   => "{$prefix}team_text_color",
        'type' => 'select',
        'options' => array(
           'text-dark'  => esc_html__('Text Color Dark', 'oxpitan'),
           'text-light'  => esc_html__('Text Color White', 'oxpitan'),
        ),
        'multiple' => false,
        'std'  => 'text-dark',
        'desc' => esc_html__('Choose what link will be used for the image(s) and title of the item.', 'oxpitan')
     ),
    )
  );

  $meta_boxes[] = array(
    'id'    => 'metaboxes_give_forms',
    'title' => esc_html__('Give Forms Settings', 'oxpitan'),
    'pages' => array( 'give_forms' ),
    'priority' => 'high',
    'fields' => array(
     array (
        'name'   => esc_html__('Gallery Images', 'oxpitan'),
        'id'    => "{$prefix}give_gallery_images",
        'type'             => 'image_advanced',
        'max_file_uploads' => 50,
      ),
      array(
        'name' => esc_html__('Video URL', 'oxpitan'),
        'id' => $prefix . 'give_video_url',
        'type' => 'text'
      ),
      array(
        'name' => esc_html__('Featured', 'oxpitan'),   
        'id'   => "{$prefix}give_featured",
        'type' => 'checkbox',
        'std'  => 0,
      ),
      array(
        'name'    => esc_html__('Color', 'oxpitan'),
        'id'      => "{$prefix}give_color",
        'type'    => 'select',
        'options' => oxpitan_scheme_colors()
      )
    )
  );

   return $meta_boxes;
 }  
  /********************* META BOX REGISTERING ***********************/
  add_filter( 'rwmb_meta_boxes', 'oxpitan_register_meta_boxes' , 99 );

