<?php
/**
 * $Desc
 *
 * @version    1.0
 * @package    basetheme
 * @author     gaviasthemes Team     
 * @copyright  Copyright (C) 2016 gaviasthemes. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 * 
 */ 
$oxpitan_options = oxpitan_get_options();
$oxpitan_logo = get_template_directory_uri().'/images/logo-white.png';
if(isset($oxpitan_options['header_logo']['url']) && $oxpitan_options['header_logo']['url']){
  $oxpitan_logo = $oxpitan_options['header_logo']['url'];
}

$link_quick_button = oxpitan_get_option('link_quick_button', '');
$protocol = is_ssl() ? 'https' : 'http';
$profile_link = $protocol . '//gmpg.org/xfn/11';
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
  <meta http-equiv="content-type" content="text/html; charset=<?php bloginfo( 'charset' ); ?>">
  <meta name="apple-touch-fullscreen" content="yes"/>
  <meta name="MobileOptimized" content="320"/>
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
  <link rel="profile" href="<?php echo esc_url($profile_link) ?>">
  <?php wp_head(); ?>
</head>

<body <?php body_class() ?>>
  <div class="wrapper-page"> <!--page-->
    <?php do_action( 'oxpitan_before_header' );  ?>
    
    <header class=" header-default header-v2">
      <?php get_template_part('templates/parts/topbar'); ?>
      
      <?php do_action( 'oxpitan_header_mobile' ); ?>

      <div class="d-none d-xl-block d-lg-block <?php echo oxpitan_get_option('stick_menu', '') ?>">
        <div class="header-bottom">
          <div class="container">
            <div class="header-bottom-inner<?php echo esc_attr($link_quick_button  ? ' has-button': ''); ?>">
              <div class="logo">
                <a class="logo-theme" href="<?php echo esc_url( home_url( '/' ) ); ?>">
                  <img src="<?php echo esc_url($oxpitan_logo); ?>" alt="<?php bloginfo( 'name' ); ?>" />
                </a>
              </div>
              <div class="main-menu-inner">
                <div class="content-innter clearfix">
                  <div id="gva-mainmenu" class="main-menu">
                    <?php do_action('oxpitan_main_menu'); ?>
                  </div>
                </div> 
              </div> 
              <?php if($link_quick_button){ ?>
                <div class="quick-button">
                  <a class="btn-theme-second" href="<?php echo esc_url($link_quick_button) ?>"><?php echo oxpitan_get_option( 'link_quick_text', 'Donation Now' ) ?></a>
                </div> 
              <?php } ?>
            </div>
          </div>  
        </div>
      </div> 

    </header>
    <?php do_action( 'oxpitan_after_header' );  ?>
    
    <div id="page-content"> <!--page content-->