<?php
/**
 * Single Form Featured Image
 *
 * Displays the featured image for the single donation form - Override this template by copying it to yourtheme/give/single-give-form/featured-image.php
 * 
 * @package       Give/Templates
 * @copyright   Copyright (c) 2016, WordImpress
 * @license     https://opensource.org/licenses/gpl-license GNU Public License
 * @since       1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

global $post;

  $form_id = get_the_ID();
  $form = new Give_Donate_Form( $form_id );
  $goal = apply_filters( 'give_goal_amount_target_output', $form->goal, $form_id, $form );
  $goal_option = give_get_meta( $form_id, '_give_goal_option', true );
  $progress = 0;
  $income = apply_filters( 'give_goal_amount_raised_output', $form->get_earnings(), $form_id, $form );
  $income = empty($income) ? 0 : $income;

$goal_option = give_get_meta( $form_id, '_give_goal_option', true );
   if($goal_option == 'disabled' || !$goal_option){
      $goal = 'unlimited';
      $progress = 100;
      $income = give_currency_filter(give_format_amount( $income, array( 'sanitize' => false ) ));
   }

  if($goal == 'unlimited'){
    $progress_label = esc_html__( 'unlimited' , 'halpes' );
    $progress = 100;
  }else{
    $progress = apply_filters( 'give_goal_amount_funded_percentage_output', round( ( $income / $goal ) * 100, 1 ), $form_id, $form );
    $progress_label = $progress . '%';
    $income = give_currency_filter(give_format_amount( $income, array( 'sanitize' => false ) ));
    $goal = give_currency_filter(give_format_amount( $goal, array( 'sanitize' => false ) ));
    if($progress > 100) $progress = 100;
  }

$color_scheme = get_post_meta($post->ID, 'oxpitan_give_color', true ) ? get_post_meta($post->ID, 'oxpitan_give_color', true ) : '';

/**
 * Fires in single form template, before the form featured image.
 *
 * Allows you to add elements before the image.
 *
 * @since 1.0
 */
do_action( 'give_pre_featured_thumbnail' );
?>

<div class="images">
	<?php //Featured Thumbnail
	if ( has_post_thumbnail() ) {
		
		$image_size = give_get_option( 'featured_image_size' );
		$image      = get_the_post_thumbnail( $post->ID, apply_filters( 'single_give_form_large_thumbnail_size', ( ! empty( $image_size ) ? $image_size : 'large' ) ) );

		echo apply_filters( 'single_give_form_image_html', $image );

	} else {

		//Placeholder Image
		//echo apply_filters( 'single_give_form_image_html', sprintf( '<img src="%s" alt="%s" />', give_get_placeholder_img_src(), esc_attr__( 'Placeholder', 'oxpitan' ) ), $post->ID );

	} ?>

	<div class="funded">
     	<div class="give__progress">
       	<div class="give__progress-bar" data-progress-max="<?php echo esc_attr($progress)?>%">
	         <?php if($progress > 75){ ?>
	           <span class="percentage percentage-left"><?php echo esc_html($progress_label); ?></span>
	         <?php }else{ ?>
	           <span class="percentage"><?php echo esc_html($progress_label); ?></span>
	         <?php } ?>  
       	</div>
     	</div>
   </div>

</div>

<?php
/**
 * Fires in single form template, after the form featured image.
 *
 * Allows you to add elements after the image.
 *
 * @since 1.0
 */
do_action( 'give_post_featured_thumbnail' );
?>
