<?php
   $this->add_render_attribute('wrapper', 'class', ['gva-services-box gva-services-box-carousel']);
   $this->add_render_attribute('carousel', 'class', 'init-carousel-owl owl-carousel');
   $header_tag = 'h2';
   if($settings['header_tag']){
     $header_tag = $settings['header_tag'];
   }
  ?>

   <div <?php echo $this->get_render_attribute_string('wrapper'); ?>>
      <div <?php echo $this->get_render_attribute_string('carousel') ?> <?php echo $this->get_carousel_settings() ?>>
        <?php
        foreach ($settings['data_services'] as $service): ?>
          <?php
            $icon = $icon_image = '';
            $has_icon = ! ( empty( $service['icon'] ) && empty( $service['icon_image'] ) );
            if($service['use_icon_image'] == 'yes'){
              $icon_image = (isset($service['icon_image']['url']) && $service['icon_image']['url']) ? $service['icon_image']['url'] : '';
            }else{
              $icon = $service['icon'];
            }
            $title_html = $service['box_title'];
            if (!empty($service['link']['url'])) :
              $title_html = '<a href="' . esc_url($service['link']['url']) . '">' . $title_html . '</a>';
            endif;
            $this->add_render_attribute( 'box_title', 'class', 'title' );
            $this->add_inline_editing_attributes( 'box_title', 'none' );
          ?>
          <div class="item">
            <div class="service-item elementor-repeater-item-<?php echo esc_attr($service['_id']) ?>">
              <div class="content-inner">
                <?php if ( $has_icon ){ ?>
                  <div class="icon-inner">
                     <?php if( $service['use_icon_image'] != 'yes' ){ ?>
                        <span class="<?php echo esc_attr($icon) ?>"></span>
                     <?php }else{ ?>
                        <span class="icon icon-image"><img src="<?php echo esc_url($icon_image) ?>" alt="<?php echo esc_html($service['box_title']) ?>"/></span>
                     <?php } ?>   
                  </div>
               <?php } ?>
              </div>
              <div class="service-title">
                <<?php echo esc_attr($header_tag) ?> <?php echo $this->get_render_attribute_string( 'box_title' ); ?>>
                  <?php echo $title_html; ?>
               </<?php echo esc_attr($header_tag) ?>>
              </div>
            </div>
          </div>  
        <?php endforeach; ?>
      </div>
   </div>
  <?php
