<?php
  use Elementor\Group_Control_Image_Size;

   $settings = $this->get_settings_for_display();
   if ( empty( $settings['title_text'] ) ) {
      return;
   }
   $skin = $settings['style'];
   $title_text = $settings['title_text'];
   $description_text = $settings['description_text'];
   $this->add_render_attribute( 'block', 'class', [ 'gsc-image-content', $settings['style'] ] );
   $header_tag = 'h2';
   
   $this->add_render_attribute( 'title_text', 'class', 'title' );
   $this->add_render_attribute( 'description_text', 'class', 'desc' );

   $this->add_inline_editing_attributes( 'title_text', 'none' );
   $this->add_inline_editing_attributes( 'description_text' );

   $title_html = $settings['title_text'];
    if ( ! empty( $settings['link']['url'] ) ) {
      $this->add_render_attribute( 'link', 'href', $settings['link']['url'] );
      if ( $settings['link']['is_external'] ) {
        $this->add_render_attribute( 'link', 'target', '_blank' );
      }
      if ( $settings['link']['nofollow'] ) {
        $this->add_render_attribute( 'link', 'rel', 'nofollow' );
      }
      $title_html = '<a' . $this->get_render_attribute_string( 'link' ) . '>' . $title_html . '</a>';
    }

   ?>
      
   <?php if($skin == 'skin-v1'){ ?>
      <div <?php echo $this->get_render_attribute_string( 'block' ) ?>>
         <?php if (!empty($settings['image']['url'])) : ?>
            <div class="image">
              <?php
                $image_html = Group_Control_Image_Size::get_attachment_image_html($settings, 'image');
                echo $image_html;
              ?>
            </div>
         <?php endif; ?>
         <div class="box-content">
            <?php if($title_text){ ?>
              <<?php echo esc_attr($header_tag) ?> <?php echo $this->get_render_attribute_string( 'title_text' ); ?>>
                 <?php echo $title_html; ?>
              </<?php echo esc_attr($header_tag) ?>>
            <?php } ?> 
            <div <?php echo $this->get_render_attribute_string( 'description_text' ); ?>><?php echo wp_kses($description_text, true); ?></div>
         </div>
         <?php if(!empty($settings['link']['url'])){ ?>
             <div class="read-more"><a class="btn-black" <?php echo $this->get_render_attribute_string( 'link' ) ?>><?php echo $settings['link_text'] ?></a></div>
          <?php } ?>
      </div>
   <?php } ?>  
    
   <?php if($skin == 'skin-v2'){ ?>
      <div <?php echo $this->get_render_attribute_string( 'block' ) ?>>
         <?php if (!empty($settings['image']['url'])) : ?>
            <div class="image">
               <?php
                 $image_html = Group_Control_Image_Size::get_attachment_image_html($settings, 'image');
                 echo $image_html;
               ?>
            </div>
         <?php endif; ?>
         <div class="box-content">
            <?php if($title_text){ ?>
               <<?php echo esc_attr($header_tag) ?> <?php echo $this->get_render_attribute_string( 'title_text' ); ?>>
                  <?php echo $title_html; ?>
               </<?php echo esc_attr($header_tag) ?>>
            <?php } ?>
            <div <?php echo $this->get_render_attribute_string( 'description_text' ); ?>><?php echo wp_kses($description_text, true); ?></div>
            <?php if(!empty($settings['link']['url'])){ ?>
               <div class="read-more"><a class="btn-inline" <?php echo $this->get_render_attribute_string( 'link' ) ?>><?php echo $settings['link_text'] ?></a></div>
            <?php } ?>
         </div>  
      </div>
   <?php } ?> 

   <?php if($skin == 'skin-v3'){ ?>
      <div <?php echo $this->get_render_attribute_string( 'block' ) ?>>
        <div class="image">
          <?php if (!empty($settings['image']['url'])) : ?>
            <div class="main-background" style="background-image:url(<?php echo esc_url($settings['image']['url']) ?>);"></div>
          <?php endif; ?>
          <?php if($title_text){ ?>
             <<?php echo esc_attr($header_tag) ?> <?php echo $this->get_render_attribute_string( 'title_text' ); ?>>
                <?php echo $title_html; ?>
             </<?php echo esc_attr($header_tag) ?>>
          <?php } ?>
        </div>
        <div class="box-background"><span></span></div>
      </div>
<?php } ?> 