<?php
use Elementor\Controls_Manager;
use Elementor\Repeater;
class GVA_Elementor_Override{
   public function __construct() {
      $this->add_actions();
   }

   public function add_actions() {
      add_action( 'elementor/element/column/layout/after_section_end', [ $this, 'after_column_end' ], 10, 2 );
   }

   public function after_column_end( $obj, $args ) {

      $obj->start_controls_section(
         'gva_section_column',
         array(
            'label' => esc_html__( 'Gavias Extra Settings', 'gaviasthemer' ),
            'tab'   => Controls_Manager::TAB_LAYOUT,
         )
      );

     $obj->add_control(
         '_gva_extra_classes',
         [
            'label' => __( 'Styles Available', 'gaviasthemer' ),
            'type' => Controls_Manager::SELECT,
            'options' => [
               '' => __( '-- None --', 'gaviasthemer' ),
               'bg-overflow-left' => __( 'Background Overflow Left', 'gaviasthemer' ),
               'bg-overflow-right' => __( 'Background Overflow Right', 'gaviasthemer' ),
            ],
            'default' => 'top',
            'prefix_class' => 'column-style-',
         ]
     );

      $obj->add_control(
         '_gva_background_skew',
         [
            'label' => __( 'Background Skew', 'gaviasthemer' ),
            'type' => Controls_Manager::SELECT,
            'options' => [
               '' => __( '-- None --', 'gaviasthemer' ),
               'bg-skew-left' => __( 'Background Skew Left', 'gaviasthemer' ),
               'bg-skew-right' => __( 'Background Skew Right', 'gaviasthemer' ),
            ],
            'default' => 'top',
            'prefix_class' => 'column-',
         ]
     );

      $obj->add_responsive_control(
         'skew_width',
         [
            'label' => __( 'Skew Width', 'gaviasthemer' ),
            'type' => Controls_Manager::SLIDER,
            'default' => [
               'size' => 40,
            ],
            'range' => [
               'px' => [
                  'min' => 0,
                  'max' => 200,
               ],
            ],
            'selectors' => [
               '{{WRAPPER}}.column-bg-skew-right' => 'padding-right: {{SIZE}}{{UNIT}};',
               '{{WRAPPER}}.column-bg-skew-left' => 'padding-left: {{SIZE}}{{UNIT}};',
            ],
         ]
      );

      $obj->end_controls_section();     
   }
}

new GVA_Elementor_Override();
