<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;

/**
 * Class GVAElement_The_Events
 */
class GVAElement_The_Events extends GVAElement_Base{

    public function get_name() {
        return 'gva-the-events';
    }

    public function get_title() {
        return __('GVA Events', 'gaviasthemer');
    }

    /**
     * Get widget icon.
     *
     * Retrieve testimonial widget icon.
     *
     * @since  1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-posts-carousel';
    }

    public function get_keywords() {
        return [ 'event', 'content', 'carousel', 'grid' ];
    }

    public function get_script_depends() {
      return [
          'jquery.owl.carousel',
          'gavias.elements',
      ];
    }

    public function get_style_depends() {
        return [
            'owl-carousel-css',
        ];
    }

    private function get_categories_list(){
        $categories = array();

        $categories['none'] = __( 'None', 'gaviasthemer' );
        $taxonomy = 'tribe_events_cat';
        $tax_terms = get_terms( $taxonomy );
        if ( ! empty( $tax_terms ) && ! is_wp_error( $tax_terms ) ){
            foreach( $tax_terms as $item ) {
                $categories[$item->term_id] = $item->name;
            }
        }
        return $categories;
    }

    private function get_thumbnail_size(){
      global $_wp_additional_image_sizes; 
      $results = array(
         'full'      => 'full',
         'large'     => 'large',
         'medium'    => 'medium',
         'thumbnail' => 'thumbnail'
      );
      foreach ($_wp_additional_image_sizes as $key => $size) {
         $results[$key] = $key;
      }
      return $results;
   } 

    private function get_posts() {
        $posts = array();

        $loop = new \WP_Query( array(
            'post_type'         => array(Tribe__Events__Main::POSTTYPE),
            'posts_per_page'    => -1,
            'post_status'       =>'publish',
        ) );

        $posts['none'] = __('--None--', 'gaviasthemer');

        while ( $loop->have_posts() ) : $loop->the_post();
            $id = get_the_ID();
            $title = get_the_title();
            $posts[$id] = $title;
        endwhile;

        wp_reset_postdata();

        return $posts;
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_query',
            [
                'label' => __('Query & Layout', 'gaviasthemer'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'category_ids',
            [
                'label' => __( 'Select By Category', 'gaviasthemer' ),
                'type' => Controls_Manager::SELECT2,
                'multiple'    => true,
                'default' => '',
                'options'   => $this->get_categories_list()
            ]
        );

        $this->add_control(
            'post_ids',
            [
                'label' => __( 'Select Individually IDs', 'gaviasthemer' ),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'label_block' => true,
                'description'   => 'example: 35,36,37,38'
            ]  
        );

        $this->add_control(
            'posts_per_page',
            [
                'label' => __( 'Posts Per Page', 'gaviasthemer' ),
                'type' => Controls_Manager::NUMBER,
                'default' => 6,
            ]
        );

        $this->add_control(
            'orderby',
            [
                'label'   => __( 'Order By', 'gaviasthemer' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'post_date',
                'options' => [
                    'post_date'  => __( 'Date', 'gaviasthemer' ),
                    'post_title' => __( 'Title', 'gaviasthemer' ),
                    'event_date' => __( 'Event Start Date', 'gaviasthemer' )
                ],
            ]
        );

        $this->add_control(
            'order',
            [
                'label'   => __( 'Order', 'gaviasthemer' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'desc',
                'options' => [
                    'asc'  => __( 'ASC', 'gaviasthemer' ),
                    'desc' => __( 'DESC', 'gaviasthemer' ),
                ],
            ]
        );

        $this->add_control( // xx Layout
            'layout_heading',
            [
                'label'   => __( 'Layout', 'gaviasthemer' ),
                'type'    => Controls_Manager::HEADING,
            ]
        );
         $this->add_control(
            'layout',
            [
                'label'   => __( 'Layout Display', 'gaviasthemer' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'grid',
                'options' => [
                    'carousel'  => __( 'Carousel', 'gaviasthemer' ),
                    'grid'      => __( 'Grid', 'gaviasthemer' )
                ]
            ]
        );
        $this->add_control(
            'style',
            [
                'label'     => __('Style', 'gaviasthemer'),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'event-1'     => __( 'Event Item Style I', 'gaviasthemer' )
                ],
                'default' => 'event-1',
                'condition' => [
                    'layout' => ['carousel', 'grid']
                ]
            ]
        );
        $this->add_control(
            'image_size',
            [
               'label'     => __('Image Size', 'gaviasthemer'),
               'type'      => \Elementor\Controls_Manager::SELECT,
               'options'   => $this->get_thumbnail_size(),
               'default'   => 'oxpitan_medium'
            ]
         );

        $this->add_control(
            'pagination',
            [
                'label'     => __('Pagination', 'gaviasthemer'),
                'type'      => Controls_Manager::SWITCHER,
                'default'   => 'no',
                'condition' => [
                    'layout' => ['grid', 'list']
                ],
            ]
        );

        $this->end_controls_section();

        $this->add_control_carousel(false, array('layout' => 'carousel'));

        $this->add_control_grid(array('layout' => 'grid'));

    }

    public static function get_query_args(  $settings ) {
        $defaults = [
            'post_ids' => '',
            'category_ids' => '',
            'orderby' => 'event_date',
            'order' => 'desc',
            'posts_per_page' => 3,
            'offset' => 0,
        ];

        $settings = wp_parse_args( $settings, $defaults );
        $cats = $settings['category_ids'];
        $ids = $settings['post_ids'];
        $query_args = [
            'posts_per_page' => $settings['posts_per_page'],
            'orderby' => $settings['orderby'],
            'order' => $settings['order'],
        ];

        if($cats){
            if( is_array($cats) && count($cats) > 0 ){
                $field_name = is_numeric($cats[0]) ? 'term_id':'slug';
                $query_args['tax_query'] = array(
                    array(
                      'taxonomy' => 'tribe_events_cat',
                      'terms' => $cats,
                      'field' => $field_name,
                      'include_children' => false
                    )
                );
            }
        }
        
        if( $ids ){
          if( is_array($ids) && count($ids) > 0 ){
            $query_args['post__in'] = $ids;
            $query_args['orderby'] = 'post__in';
          }
        }

        if(is_front_page()){
            $query_args['paged'] = (get_query_var('page')) ? get_query_var('page') : 1;
        }else{
            $query_args['paged'] = (get_query_var('paged')) ? get_query_var('paged') : 1;
        }
        
        return $query_args;
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        printf( '<div class="gva-element-%s gva-element">', $this->get_name() );
        if( !empty($settings['layout']) ){
            include $this->get_template('the-events/' . $settings['layout'] . '.php');
        }
        print '</div>'; 
    }
    
}
